#!/bin/bash

#
# Usage:
#
#     TO_HOST=172.98.203.70 ./copy_indexes.sh
#

if [[ "$TO_HOST" == "" ]]; then
    echo "Please provide \$TO_HOST"
    exit 1
fi

ssh $TO_HOST "mkdir -p /home/new_sphinx"
ssh $TO_HOST "echo \"Ciphers arcfour,aes128-ctr,aes192-ctr,aes256-ctr,aes128-gcm@openssh.com,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com\" | tee -a /etc/ssh/sshd_config"
ssh $TO_HOST "service ssh restart"

screen -S "scp1" -d -m
screen -r scp1 -X stuff $"scp -C -c arcfour -rp /home/new_sphinx/0_100 root@$TO_HOST:/home/new_sphinx\n"
screen -S "scp2" -d -m
screen -r scp2 -X stuff $"scp -C -c arcfour -rp /home/new_sphinx/300_400 root@$TO_HOST:/home/new_sphinx\n"
screen -S "scp3" -d -m
screen -r scp3 -X stuff $"scp -C -c arcfour -rp /home/new_sphinx/400_500 root@$TO_HOST:/home/new_sphinx\n"

rsync -avz -e "ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null" --progress /home/new_sphinx/pid/ "root@$TO_HOST:/home/new_sphinx/pid/"
rsync -avz -e "ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null" --progress /home/new_sphinx/bin/ "root@$TO_HOST:/home/new_sphinx/bin/"
